<?php

class AUTHORIZATION
{
    public static function validateTimestamp($token)
    {
        $CI = &get_instance();
        $CI->load->model('data_menu');
        $CI->load->helper(['toolkit']);
        $token = self::validateToken($token);
        if ($token != false && (now() - $token->timestamp < ($CI->config->item('token_timeout') * 60))) {
            return $token;
        }
        return false;
    }

    public static function validateToken($token)
    {
        $CI = &get_instance();
        return JWT::decode($token, $CI->config->item('jwt_key'));
    }

    public static function generateToken($data)
    {
        $CI = &get_instance();
        return JWT::encode($data, $CI->config->item('jwt_key'));
    }

    public static function ThrowBadRequest($message)
    {
        $code = (int)AUTHORIZATION::HTTP_CODE_RETURN_BPJS() ;
        
        http_response_code(AUTHORIZATION::HTTP_CODE_BAD_REQUEST());
        $result = array(
            'message' => $message,
            'code' => $code
        );
        $metadata = array('metadata' => $result);
        echo json_encode($metadata);
        exit();
    }

    public static function ThrowUnAuthorizedRequest($message)
    {
        http_response_code(AUTHORIZATION::HTTP_CODE_UNAUTHORIZED());
        $result = array(
            'message' => $message,
            'code' => (int)AUTHORIZATION::HTTP_CODE_RETURN_BPJS()
        );
        $metadata = array('metadata' => $result);
        echo json_encode($metadata);
        exit();
    }

    public static function ThrowUnMethodNotAllowed($message)
    {
        http_response_code(AUTHORIZATION::HTTP_CODE_METHOD_NOT_ALLOWED());
        $result = array(
            'message' => $message,
            'code' => (int)AUTHORIZATION::HTTP_CODE_METHOD_NOT_ALLOWED()
        );
        $metadata = array('metadata' => $result);
        echo json_encode($metadata);
        exit();
    }

    public static function ThrowInternalServerError($message)
    {
        http_response_code(AUTHORIZATION::HTTP_CODE_INTERNAL_SERVER_ERROR());
        $result = array(
            'message' => $message,
            'code' => (int)AUTHORIZATION::HTTP_CODE_INTERNAL_SERVER_ERROR()
        );
        $metadata = array('metadata' => $result);
        echo json_encode($metadata);
        exit();
    }

    public static function TokenValidation()
    {
        $CI = &get_instance();
        // Get all the headers
        $headers = $CI->input->request_headers();
        // Extract the token

        if(isset($headers['x-token'])){
            $token = $headers['x-token'];
            $username = $headers['x-username'];
        }else{
            $token = $headers['X-Token'];
            $username = $headers['X-Username'];
        }
        
        $decode = JWT::decode($token);
        //check token is valid
        if (!$decode) {
            AUTHORIZATION::ThrowUnAuthorizedRequest('UnAuthorized');
        }
        $obj = array(
            "username" => $username,
            "password" => ''
        );
        // check username is valid in db
        $accessDb = AUTHORIZATION::HttpRequest($obj, 'GetAccess');
        $accessDb = json_decode($accessDb, true);
        if (empty($accessDb)) {
            AUTHORIZATION::ThrowUnAuthorizedRequest('UnAuthorized');
        }
    }


    public static function HTTP_CODE_BAD_REQUEST()
    {
        return '200';
    }

    public static function HTTP_CODE_SUCCESS()
    {
        return '200';
    }

    public static function HTTP_CODE_UNAUTHORIZED()
    {
        return '401';
    }

    public static function HTTP_CODE_METHOD_NOT_ALLOWED()
    {
        return '405';
    }

    public static function HTTP_CODE_INTERNAL_SERVER_ERROR()
    {
        return '500';
    }

    public static function HTTP_CODE_RETURN_BPJS()
    {
        return '201';
    }

    public static function HTTP_MESSAGE_UNAUTHORIZED()
    {
        return 'UnAuthorized';
    }

    public static function URL_BPJS_PURWA()
    {
        return 'http://public.harapankeluarga.com/Api/index.php/WsBpjsJkn/';
    }

    public static function HttpRequest($params, $endPoint)
    {
        $CI = &get_instance();
        return $CI->libhttprequest->HitPostJson($params, $endPoint);
    }
}
